/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.indexer;

import com.aptana.editor.php.internal.indexer.AbstractPHPEntryValue;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ClassPHPEntryValue
extends AbstractPHPEntryValue {
    private String superClassName;
    private List<String> interfaces;
    private int endOffset;
    private List<String> traits;

    public ClassPHPEntryValue(int modifiers, String namespace) {
        super(modifiers, namespace);
    }

    public ClassPHPEntryValue(int modifiers, String superClassName, List<String> interfaces, String namespace) {
        super(modifiers, namespace);
        this.superClassName = superClassName;
        this.interfaces = interfaces;
    }

    public ClassPHPEntryValue(DataInputStream di) throws IOException {
        super(di);
        this.internalRead(di);
    }

    public void setInterfaces(List<String> interfaces) {
        this.interfaces = interfaces;
    }

    public String getSuperClassname() {
        return this.superClassName;
    }

    public void setSuperClassName(String superClassname) {
        this.superClassName = superClassname;
    }

    public List<String> getInterfaces() {
        return this.interfaces;
    }

    public void setTraits(List<String> traits) {
        this.traits = traits;
    }

    public List<String> getTraits() {
        return this.traits;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.interfaces == null ? 0 : this.interfaces.hashCode());
        result = 31 * result + (this.superClassName == null ? 0 : this.superClassName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassPHPEntryValue other = (ClassPHPEntryValue)obj;
        if (this.interfaces == null ? other.interfaces != null : !this.listsEquals(this.interfaces, other.interfaces)) {
            return false;
        }
        return !(this.superClassName == null ? other.superClassName != null : !this.superClassName.equals(other.superClassName));
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    private boolean listsEquals(List<String> list1, List<String> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        int i = 0;
        while (i < list1.size()) {
            String str2;
            String str1 = list1.get(i);
            if (!str1.equals(str2 = list2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int getKind() {
        return 1;
    }

    @Override
    protected void internalWrite(DataOutputStream da) throws IOException {
        da.writeInt(this.endOffset);
        String s = this.superClassName != null ? this.superClassName : "";
        da.writeUTF(s);
        List emptyList = Collections.emptyList();
        List<Object> inter = this.interfaces != null ? this.interfaces : emptyList;
        da.writeInt(inter.size());
        for (String string : inter) {
            da.writeUTF(string);
        }
    }

    @Override
    protected void internalRead(DataInputStream di) throws IOException {
        this.endOffset = di.readInt();
        this.superClassName = di.readUTF().intern();
        int sz = di.readInt();
        if (sz == 0) {
            this.interfaces = Collections.emptyList();
        }
        if (sz == 1) {
            this.interfaces = Collections.singletonList(di.readUTF());
        } else {
            ArrayList<String> s = new ArrayList<String>(sz);
            int a = 0;
            while (a < sz) {
                s.add(di.readUTF());
                ++a;
            }
            this.interfaces = s;
        }
    }
}

